<?php

require_once '../core/Controller.php';

class AuthController extends Controller
{
    private $agentModel;

    public function __construct()
    {
        parent::__construct();
        $this->agentModel = $this->loadModel('Agent');
    }

    public function showLogin()
    {
        if ($this->isAuthenticated()) {
            $this->redirect('/dashboard');
        }

        return $this->view->render('auth.login', [
            'title' => 'Login'
        ], 'auth');
    }

    public function login()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            $this->redirect('/login');
        }

        $agentCode = $_POST['agent_code'] ?? '';
        $password = $_POST['password'] ?? '';

        if (empty($agentCode) || empty($password)) {
            $this->setFlashMessage('error', 'Error', 'Agent Code and Password are required');
            $this->redirect('/login');
        }

        $agent = $this->agentModel->authenticate($agentCode, md5($password));

        if (!$agent) {
            $this->setFlashMessage('error', 'Error', 'Invalid credentials');
            $this->redirect('/login');
        }

        if ($agent['agent_status'] === 'blocked') {
            $this->setFlashMessage('error', 'Error', 'Account is blocked');
            $this->redirect('/login');
        }

        $_SESSION['admin'] = $agent;
        $this->setFlashMessage('success', 'Success', 'Login successful');
        $this->redirect('/dashboard');
    }

    public function logout()
    {
        session_destroy();
        $this->redirect('/login');
    }

    public function showRegister()
    {
        if ($this->isAuthenticated()) {
            $this->redirect('/dashboard');
        }

        return $this->view->render('auth.register', [
            'title' => 'Register'
        ], 'auth');
    }

    public function register()
    {
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            $this->redirect('/register');
        }

        $agentName = $_POST['agent_name'] ?? '';
        $password = $_POST['password'] ?? '';
        $confirmPassword = $_POST['confirm_password'] ?? '';

        // Validation
        if (strlen($agentName) < 5 || strlen($agentName) > 8) {
            $this->setFlashMessage('error', 'Error', 'Agent Name must be 5-8 characters');
            $this->redirect('/register');
        }

        if ($password !== $confirmPassword) {
            $this->setFlashMessage('error', 'Error', 'Passwords do not match');
            $this->redirect('/register');
        }

        if ($this->agentModel->findBy('agent_name', $agentName)) {
            $this->setFlashMessage('error', 'Error', 'Agent name already exists');
            $this->redirect('/register');
        }

        // Create new agent
        $agentData = [
            'agent_code' => $this->generateAgentCode(),
            'agent_name' => $agentName,
            'agent_token' => md5(uniqid()),
            'agent_password' => md5($password),
            'agent_upline' => 'sistem',
            'agent_created' => date('Y-m-d H:i:s'),
            'agent_balance' => 0,
            'agent_level' => 'agent',
            'agent_status' => 'active'
        ];

        if ($this->agentModel->create($agentData)) {
            $agent = $this->agentModel->findBy('agent_code', $agentData['agent_code']);
            $_SESSION['admin'] = $agent;
            $this->setFlashMessage('success', 'Success', 'Registration successful');
            $this->redirect('/dashboard');
        } else {
            $this->setFlashMessage('error', 'Error', 'Registration failed');
            $this->redirect('/register');
        }
    }

    private function generateAgentCode()
    {
        $characters = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ';
        do {
            $code = '';
            for ($i = 0; $i < 8; $i++) {
                $code .= $characters[rand(0, strlen($characters) - 1)];
            }
        } while ($this->agentModel->findBy('agent_code', $code));
        
        return $code;
    }
}