<?php
// app/Controllers/DocumentationController.php - API Documentation Controller

require_once '../core/Controller.php';

class DocumentationController extends Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index()
    {
        $this->requireAuth();
        
        $currentAgent = $_SESSION['admin'];
        $apiBase = "https://api." . $_SERVER['SERVER_NAME'] . "/v1/";
        
        return $this->view->render('docs.index', [
            'title' => 'API Documentation',
            'agent' => $currentAgent,
            'apiBase' => $apiBase,
            'flash' => $this->getFlashMessage()
        ]);
    }
}