<?php
// app/Controllers/TransactionController.php - Transaction Management Controller

require_once '../core/Controller.php';

class TransactionController extends Controller
{
    private $transactionModel;
    private $agentModel;

    public function __construct()
    {
        parent::__construct();
        $this->transactionModel = $this->loadModel('Transaction');
        $this->agentModel = $this->loadModel('Agent');
    }

    public function index()
    {
        $this->requireAuth();
        
        $currentAgent = $_SESSION['admin'];
        $transactions = $this->transactionModel->getAgentTransactions($currentAgent['agent_code']);
        
        return $this->view->render('transactions.index', [
            'title' => 'Transaction Management',
            'transactions' => $transactions,
            'flash' => $this->getFlashMessage()
        ]);
    }

    public function balance()
    {
        $this->requireAuth();
        
        return $this->view->render('transactions.balance', [
            'title' => 'Balance TopUp',
            'flash' => $this->getFlashMessage()
        ]);
    }

    public function topup()
    {
        $this->requireAuth();
        
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            $this->redirect('/transactions/balance');
        }

        $currentAgent = $_SESSION['admin'];
        $amount = (float)($_POST['amount'] ?? 0);
        $whatsapp = $_POST['whatsapp'] ?? '';
        $method = $_POST['method'] ?? '';

        if ($amount < 500000) {
            $this->setFlashMessage('error', 'Error', 'Minimum topup amount is 500,000');
            $this->redirect('/transactions/balance');
        }

        if (empty($whatsapp) || empty($method)) {
            $this->setFlashMessage('error', 'Error', 'All fields are required');
            $this->redirect('/transactions/balance');
        }

        // Create topup request
        $trxId = md5(uniqid());
        $topupData = [
            'trxid' => $trxId,
            'agent_code' => $currentAgent['agent_code'],
            'balance' => $amount,
            'amount' => $amount,
            'created' => date('Y-m-d H:i:s'),
            'date_created' => date('Y-m-d'),
            'metode' => $method,
            'status' => 'Pending',
            'whatsapp' => $whatsapp,
            'checkout' => 'https://payment.example.com/checkout/' . $trxId
        ];

        if ($this->transactionModel->create($topupData)) {
            $this->setFlashMessage('success', 'Success', 'Topup request created successfully');
        } else {
            $this->setFlashMessage('error', 'Error', 'Failed to create topup request');
        }

        $this->redirect('/transactions/balance');
    }

    public function history()
    {
        $this->requireAuth();
        
        $currentAgent = $_SESSION['admin'];
        $dailyTransactions = $this->transactionModel->getDailyTransactions($currentAgent['agent_code']);
        
        return $this->view->render('transactions.history', [
            'title' => 'Transaction History',
            'dailyTransactions' => $dailyTransactions,
            'flash' => $this->getFlashMessage()
        ]);
    }
}