<?php

require_once '../core/Controller.php';

class UserController extends Controller
{
    private $userModel;
    private $transactionModel;

    public function __construct()
    {
        parent::__construct();
        $this->userModel = $this->loadModel('User');
        $this->transactionModel = $this->loadModel('Transaction');
    }

    public function index()
    {
        $this->requireAuth();
        
        $currentAgent = $_SESSION['admin'];
        $agentCode = $currentAgent['agent_code'];
        
        if ($currentAgent['agent_level'] === 'admin') {
            $users = $this->userModel->all();
        } else {
            $users = $this->userModel->getByAgent($agentCode);
        }
        
        return $this->view->render('users.index', [
            'title' => 'User Management',
            'users' => $users,
            'flash' => $this->getFlashMessage()
        ]);
    }

    public function details($params)
    {
        $this->requireAuth();
        
        $user = $this->userModel->find($params['id']);
        if (!$user) {
            $this->setFlashMessage('error', 'Error', 'User not found');
            $this->redirect('/users');
        }

        return $this->view->render('users.details', [
            'title' => 'User Details',
            'user' => $user,
            'flash' => $this->getFlashMessage()
        ]);
    }

    public function bettingHistory()
    {
        $this->requireAuth();
        
        $currentAgent = $_SESSION['admin'];
        $agentCode = $currentAgent['agent_code'];
        
        $bettingStats = $this->userModel->getBettingStats($agentCode);
        
        return $this->view->render('users.betting-history', [
            'title' => 'Betting History',
            'stats' => $bettingStats,
            'flash' => $this->getFlashMessage()
        ]);
    }

    public function transactions()
    {
        $this->requireAuth();
        
        $currentAgent = $_SESSION['admin'];
        $transactions = $this->transactionModel->getAgentTransactions($currentAgent['agent_code']);
        
        return $this->view->render('users.transactions', [
            'title' => 'User Transactions',
            'transactions' => $transactions,
            'flash' => $this->getFlashMessage()
        ]);
    }

    public function onlineUsers()
    {
        $this->requireAuth();
        
        return $this->view->render('users.online', [
            'title' => 'Online Users',
            'flash' => $this->getFlashMessage()
        ]);
    }

    public function controlRtp()
    {
        $this->requireAuth();
        
        if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
            return $this->json(['status' => 'error', 'message' => 'Invalid request method']);
        }

        $input = json_decode(file_get_contents('php://input'), true);
        $userCode = $input['user_code'] ?? '';
        $providerCode = $input['provider_code'] ?? '';
        $rtp = (int)($input['rtp'] ?? 0);

        if (empty($userCode) || empty($providerCode) || $rtp < 1 || $rtp > 95) {
            return $this->json(['status' => 'error', 'message' => 'Invalid parameters']);
        }

        require_once '../app/Services/NexusGamingApi.php';
        $currentAgent = $_SESSION['admin'];
        $api = new NexusGamingApi($currentAgent['agent_code'], $currentAgent['agent_token']);

        $response = $api->controlUserRtp($providerCode, $userCode, $rtp);

        if ($response['status'] == 1) {
            return $this->json([
                'status' => 'success',
                'message' => 'RTP updated successfully',
                'data' => ['new_rtp' => $response['changed_rtp']]
            ]);
        } else {
            return $this->json([
                'status' => 'error',
                'message' => $response['msg']
            ], 400);
        }
    }
}