<?php

require_once '../core/Model.php';

class Agent extends Model
{
    protected $table = 'tb_agent';
    protected $primaryKey = 'id';

    public function authenticate($agentCode, $hashedPassword)
    {
        $stmt = $this->db->prepare("SELECT * FROM {$this->table} WHERE agent_code = ? AND agent_password = ?");
        $stmt->execute([$agentCode, $hashedPassword]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function getBalance($agentCode)
    {
        $agent = $this->findBy('agent_code', $agentCode);
        return $agent ? $agent['agent_balance'] : 0;
    }

    public function updateBalance($agentCode, $newBalance)
    {
        $stmt = $this->db->prepare("UPDATE {$this->table} SET agent_balance = ? WHERE agent_code = ?");
        return $stmt->execute([$newBalance, $agentCode]);
    }

    public function addBalance($agentCode, $amount)
    {
        $stmt = $this->db->prepare("UPDATE {$this->table} SET agent_balance = agent_balance + ? WHERE agent_code = ?");
        return $stmt->execute([$amount, $agentCode]);
    }

    public function subtractBalance($agentCode, $amount)
    {
        $stmt = $this->db->prepare("UPDATE {$this->table} SET agent_balance = agent_balance - ? WHERE agent_code = ? AND agent_balance >= ?");
        return $stmt->execute([$amount, $agentCode, $amount]);
    }

    public function getSubAgents($parentCode)
    {
        return $this->where(['agent_upline' => $parentCode], 'agent_created DESC');
    }

    public function getAllAgentsForAdmin()
    {
        return $this->all();
    }

    public function getAgentStats($agentCode)
    {
        $stmt = $this->db->prepare("
            SELECT 
                a.*,
                COUNT(u.id) as total_users,
                COALESCE(SUM(u.balance), 0) as total_user_balance,
                COUNT(sub.id) as total_sub_agents
            FROM {$this->table} a
            LEFT JOIN tb_user u ON u.agent_code = a.agent_code
            LEFT JOIN {$this->table} sub ON sub.agent_upline = a.agent_code
            WHERE a.agent_code = ?
            GROUP BY a.id
        ");
        $stmt->execute([$agentCode]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function blockAgent($agentCode)
    {
        return $this->update($agentCode, ['agent_status' => 'blocked']);
    }

    public function unblockAgent($agentCode)
    {
        return $this->update($agentCode, ['agent_status' => 'active']);
    }
}