<?php
// app/Models/Balance.php - Balance Model for TopUp Management

require_once '../core/Model.php';

class Balance extends Model
{
    protected $table = 'tb_balance';
    protected $primaryKey = 'id';

    public function createTopupRequest($data)
    {
        $topupData = [
            'trxid' => $data['trxid'],
            'agent_code' => $data['agent_code'],
            'balance' => $data['balance'],
            'amount' => $data['amount'],
            'created' => date('Y-m-d H:i:s'),
            'date_created' => date('Y-m-d'),
            'metode' => $data['metode'],
            'status' => 'Pending',
            'whatsapp' => $data['whatsapp'],
            'checkout' => $data['checkout'] ?? null
        ];
        
        return $this->create($topupData);
    }

    public function getAgentTopups($agentCode)
    {
        return $this->where(['agent_code' => $agentCode], 'created DESC');
    }

    public function getPendingTopups()
    {
        return $this->where(['status' => 'Pending'], 'created DESC');
    }

    public function updateTopupStatus($trxId, $status)
    {
        $topup = $this->findBy('trxid', $trxId);
        if ($topup) {
            return $this->update($topup['id'], ['status' => $status]);
        }
        return false;
    }

    public function getTopupStats($agentCode = null)
    {
        $sql = "
            SELECT 
                COUNT(*) as total_requests,
                COALESCE(SUM(CASE WHEN status = 'Pending' THEN amount ELSE 0 END), 0) as pending_amount,
                COALESCE(SUM(CASE WHEN status = 'Success' THEN amount ELSE 0 END), 0) as success_amount,
                COALESCE(SUM(CASE WHEN status = 'Cancel' THEN amount ELSE 0 END), 0) as cancelled_amount
            FROM {$this->table}
        ";
        $params = [];
        
        if ($agentCode) {
            $sql .= " WHERE agent_code = ?";
            $params[] = $agentCode;
        }
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetch();
    }
}