<?php

require_once '../core/Model.php';

class Game extends Model
{
    protected $table = 'tb_game';
    protected $primaryKey = 'id';

    public function getProviders()
    {
        $stmt = $this->db->query("SELECT DISTINCT game_provider FROM {$this->table} WHERE game_status = 1 ORDER BY game_provider");
        return $stmt->fetchAll();
    }

    public function getGamesByProvider($provider)
    {
        return $this->where(['game_provider' => $provider, 'game_status' => 1], 'game_name ASC');
    }

    public function searchGames($keyword)
    {
        $stmt = $this->db->prepare("SELECT * FROM {$this->table} WHERE game_name LIKE ? AND game_status = 1");
        $stmt->execute(["%{$keyword}%"]);
        return $stmt->fetchAll();
    }

    public function getActiveGames()
    {
        return $this->where(['game_status' => 1], 'game_name ASC');
    }

    public function syncGame($gameData)
    {
        $existing = $this->findBy('game_code', $gameData['game_code']);
        
        if ($existing) {
            return $this->update($existing['id'], [
                'game_name' => $gameData['game_name'],
                'game_provider' => $gameData['game_provider'],
                'game_type' => $gameData['game_type'],
                'game_image' => $gameData['game_image'],
                'game_status' => $gameData['game_status']
            ]);
        } else {
            return $this->create($gameData);
        }
    }

    public function getGameStats()
    {
        $stmt = $this->db->query("
            SELECT 
                COUNT(*) as total_games,
                COUNT(CASE WHEN game_status = 1 THEN 1 END) as active_games,
                COUNT(CASE WHEN game_type = 'slot' THEN 1 END) as slot_games,
                COUNT(CASE WHEN game_type = 'live' THEN 1 END) as live_games
            FROM {$this->table}
        ");
        return $stmt->fetch();
    }
}