<?php
// app/Models/Provider.php - Game Provider Model

require_once '../core/Model.php';

class Provider extends Model
{
    protected $table = 'tb_provider';
    protected $primaryKey = 'id';

    public function getActiveProviders()
    {
        return $this->where(['provider_status' => 1], 'provider_name ASC');
    }

    public function syncProvider($providerData)
    {
        $existing = $this->findBy('provider_code', $providerData['provider_code']);
        
        if ($existing) {
            return $this->update($existing['id'], [
                'provider_name' => $providerData['provider_name'],
                'provider_type' => $providerData['provider_type'],
                'provider_image' => $providerData['provider_image'],
                'provider_status' => $providerData['provider_status']
            ]);
        } else {
            return $this->create($providerData);
        }
    }

    public function getProviderStats()
    {
        $stmt = $this->db->query("
            SELECT 
                COUNT(*) as total_providers,
                COUNT(CASE WHEN provider_status = 1 THEN 1 END) as active_providers,
                COUNT(CASE WHEN provider_type = 'slot' THEN 1 END) as slot_providers,
                COUNT(CASE WHEN provider_type = 'live' THEN 1 END) as live_providers
            FROM {$this->table}
        ");
        return $stmt->fetch();
    }

    public function getProviderWithGames()
    {
        $stmt = $this->db->query("
            SELECT 
                p.*,
                COUNT(g.id) as game_count
            FROM {$this->table} p
            LEFT JOIN tb_game g ON g.game_provider = p.provider_code
            WHERE p.provider_status = 1
            GROUP BY p.id
            ORDER BY p.provider_name ASC
        ");
        return $stmt->fetchAll();
    }
}