<?php

require_once '../core/Model.php';

class Transaction extends Model
{
    protected $table = 'tb_transaction';
    protected $primaryKey = 'id';

    public function getTotalBetting($agentCode = null)
    {
        $sql = "SELECT COUNT(*) FROM tb_history";
        $params = [];
        
        if ($agentCode) {
            $sql .= " WHERE agent_code = ?";
            $params[] = $agentCode;
        }
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchColumn();
    }

    public function createTransaction($data)
    {
        $transactionData = [
            'trxid' => $data['trxid'],
            'intUser' => $data['intUser'],
            'extUser' => $data['extUser'],
            'type' => $data['type'],
            'amount' => $data['amount'],
            'before_agent_balance' => $data['before_agent_balance'],
            'after_agent_balance' => $data['after_agent_balance'],
            'agent_code' => $data['agent_code'],
            'created' => date('Y-m-d H:i:s')
        ];
        
        return $this->create($transactionData);
    }

    public function getAgentTransactions($agentCode)
    {
        return $this->where(['agent_code' => $agentCode], 'created DESC');
    }

    public function getTransactionStats($agentCode = null)
    {
        $sql = "
            SELECT 
                COUNT(*) as total_transactions,
                COALESCE(SUM(CASE WHEN type = 'deposit' THEN amount ELSE 0 END), 0) as total_deposits,
                COALESCE(SUM(CASE WHEN type = 'withdraw' THEN amount ELSE 0 END), 0) as total_withdrawals
            FROM {$this->table}
        ";
        $params = [];
        
        if ($agentCode) {
            $sql .= " WHERE agent_code = ?";
            $params[] = $agentCode;
        }
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetch();
    }

    public function getDailyTransactions($agentCode = null, $days = 7)
    {
        $sql = "
            SELECT 
                DATE(created) as date,
                COUNT(*) as count,
                COALESCE(SUM(amount), 0) as total
            FROM {$this->table}
            WHERE created >= DATE_SUB(NOW(), INTERVAL ? DAY)
        ";
        $params = [$days];
        
        if ($agentCode) {
            $sql .= " AND agent_code = ?";
            $params[] = $agentCode;
        }
        
        $sql .= " GROUP BY DATE(created) ORDER BY date DESC";
        
        $stmt = $this->db->prepare($sql);
        $stmt->execute($params);
        return $stmt->fetchAll();
    }
}