<div class="row">
    <!-- Statistics Cards -->
    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-primary">
            <div class="card-body pb-0 d-flex justify-content-between align-items-start">
                <div>
                    <div class="fs-4 fw-semibold"><?= number_format($stats['totalMembers']) ?></div>
                    <div>Total Members</div>
                </div>
                <div class="dropdown">
                    <i class="cil-people stats-icon"></i>
                </div>
            </div>
            <div class="c-chart-wrapper mt-3 mx-3" style="height:70px;">
                <canvas class="chart" id="card-chart1" height="70"></canvas>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-success">
            <div class="card-body pb-0 d-flex justify-content-between align-items-start">
                <div>
                    <div class="fs-4 fw-semibold"><?= number_format($stats['totalBalance']) ?></div>
                    <div>Total Balance</div>
                </div>
                <div class="dropdown">
                    <i class="cil-credit-card stats-icon"></i>
                </div>
            </div>
            <div class="c-chart-wrapper mt-3 mx-3" style="height:70px;">
                <canvas class="chart" id="card-chart2" height="70"></canvas>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-warning">
            <div class="card-body pb-0 d-flex justify-content-between align-items-start">
                <div>
                    <div class="fs-4 fw-semibold"><?= number_format($stats['totalBetting']) ?></div>
                    <div>Total Betting</div>
                </div>
                <div class="dropdown">
                    <i class="cil-chart-pie stats-icon"></i>
                </div>
            </div>
            <div class="c-chart-wrapper mt-3 mx-3" style="height:70px;">
                <canvas class="chart" id="card-chart3" height="70"></canvas>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-info">
            <div class="card-body pb-0 d-flex justify-content-between align-items-start">
                <div>
                    <div class="fs-4 fw-semibold"><?= number_format($stats['totalGames']) ?></div>
                    <div>Total Games</div>
                </div>
                <div class="dropdown">
                    <i class="cil-gamepad stats-icon"></i>
                </div>
            </div>
            <div class="c-chart-wrapper mt-3 mx-3" style="height:70px;">
                <canvas class="chart" id="card-chart4" height="70"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- Agent Information Row -->
<div class="row mt-4">
    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-secondary">
            <div class="card-body pb-0 d-flex justify-content-between align-items-start">
                <div>
                    <div class="fs-4 fw-semibold"><?= number_format($stats['agentBalance']) ?></div>
                    <div>Your Balance</div>
                </div>
                <div class="dropdown">
                    <i class="cil-wallet stats-icon"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-dark">
            <div class="card-body pb-0 d-flex justify-content-between align-items-start">
                <div>
                    <div class="fs-4 fw-semibold"><?= number_format($stats['totalAgents']) ?></div>
                    <div>Sub Agents</div>
                </div>
                <div class="dropdown">
                    <i class="cil-people stats-icon"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-primary">
            <div class="card-body pb-0 d-flex justify-content-between align-items-start">
                <div>
                    <div class="fs-6 fw-semibold"><?= $agent['agent_code'] ?></div>
                    <div>Agent Code</div>
                </div>
                <div class="dropdown">
                    <i class="cil-user stats-icon"></i>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <i class="cil-speedometer"></i> Quick Actions
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-sm-6 col-lg-3 mb-2">
                        <a href="/agents/create" class="btn btn-primary btn-block">
                            <i class="cil-plus"></i> Add New Agent
                        </a>
                    </div>
                    <div class="col-sm-6 col-lg-3 mb-2">
                        <a href="/transactions/balance" class="btn btn-success btn-block">
                            <i class="cil-credit-card"></i> TopUp Balance
                        </a>
                    </div>
                    <div class="col-sm-6 col-lg-3 mb-2">
                        <a href="/users" class="btn btn-info btn-block">
                            <i class="cil-people"></i> View Users
                        </a>
                    </div>
                    <div class="col-sm-6 col-lg-3 mb-2">
                        <a href="/docs" class="btn btn-warning btn-block">
                            <i class="cil-description"></i> API Docs
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Recent Activity -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <i class="cil-list"></i> Recent Activity
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Time</th>
                                <th>Activity</th>
                                <th>Details</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><?= date('H:i:s') ?></td>
                                <td>System Status</td>
                                <td>All systems operational</td>
                                <td><span class="badge badge-success">Active</span></td>
                            </tr>
                            <tr>
                                <td><?= date('H:i:s', strtotime('-5 minutes')) ?></td>
                                <td>API Connection</td>
                                <td>Gaming API connected successfully</td>
                                <td><span class="badge badge-success">Connected</span></td>
                            </tr>
                            <tr>
                                <td><?= date('H:i:s', strtotime('-10 minutes')) ?></td>
                                <td>Database Sync</td>
                                <td>Game data synchronized</td>
                                <td><span class="badge badge-info">Completed</span></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Auto-refresh stats every 30 seconds
setInterval(function() {
    fetch('/dashboard/stats')
        .then(response => response.json())
        .then(data => {
            if (data.status === 'success') {
                // Update stats display
                console.log('Stats updated:', data.data);
            }
        })
        .catch(error => console.error('Error refreshing stats:', error));
}, 30000);
</script>