<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4><i class="cil-description"></i> API Documentation v1.0.0</h4>
            </div>
            <div class="card-body">
                <div class="alert alert-info">
                    <strong>API Base URL:</strong> <?= $apiBase ?>
                    <br><strong>Your Agent Code:</strong> <?= $agent['agent_code'] ?>
                    <br><strong>Your Agent Token:</strong> <?= $agent['agent_token'] ?>
                </div>

                <h5>Authentication</h5>
                <p>All API requests require agent authentication using <code>agent_token</code> and <code>agent_code</code> parameters.</p>

                <h5>Endpoints</h5>
                
                <div class="card mt-3">
                    <div class="card-header">
                        <h6>1. Create Member</h6>
                    </div>
                    <div class="card-body">
                        <p><strong>Endpoint:</strong> <code>GET <?= $apiBase ?>CreateMember.aspx</code></p>
                        <p><strong>Parameters:</strong></p>
                        <ul>
                            <li><code>agent_token</code> - Your agent token</li>
                            <li><code>agent_code</code> - Your agent code</li>
                            <li><code>username</code> - Username to create</li>
                        </ul>
                        <p><strong>Example:</strong></p>
                        <pre><code><?= $apiBase ?>CreateMember.aspx?agent_token=<?= $agent['agent_token'] ?>&agent_code=<?= $agent['agent_code'] ?>&username=TEST123</code></pre>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h6>2. Get User Balance</h6>
                    </div>
                    <div class="card-body">
                        <p><strong>Endpoint:</strong> <code>GET <?= $apiBase ?>GetBalance.ashx</code></p>
                        <p><strong>Parameters:</strong></p>
                        <ul>
                            <li><code>agent_token</code> - Your agent token</li>
                            <li><code>agent_code</code> - Your agent code</li>
                            <li><code>username</code> - Username to check</li>
                        </ul>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h6>3. Make Transfer</h6>
                    </div>
                    <div class="card-body">
                        <p><strong>Endpoint:</strong> <code>GET <?= $apiBase ?>MakeTransfer.aspx</code></p>
                        <p><strong>Parameters:</strong></p>
                        <ul>
                            <li><code>agent_token</code> - Your agent token</li>
                            <li><code>agent_code</code> - Your agent code</li>
                            <li><code>username</code> - Target username</li>
                            <li><code>amount</code> - Transfer amount</li>
                            <li><code>type</code> - deposit or withdraw</li>
                        </ul>
                    </div>
                </div>

                <div class="card mt-3">
                    <div class="card-header">
                        <h6>PHP cURL Example</h6>
                    </div>
                    <div class="card-body">
                        <pre><code>$endpoint = "<?= $apiBase ?>CreateMember.aspx?agent_token=<?= $agent['agent_token'] ?>&agent_code=<?= $agent['agent_code'] ?>&username=TEST123";

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $endpoint);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

$response = curl_exec($ch);
curl_close($ch);

$result = json_decode($response, true);
print_r($result);</code></pre>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>