<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Gaming Agregator' ?> | Gaming Admin Panel</title>
    
    <!-- CoreUI CSS -->
    <link href="https://cdn.jsdelivr.net/npm/@coreui/coreui@4.2.6/dist/css/coreui.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@coreui/icons/css/coreui-icons.min.css" rel="stylesheet">
    
    <!-- Custom CSS -->
    <style>
        .card-stats {
            background: linear-gradient(45deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        .stats-icon {
            font-size: 2rem;
            opacity: 0.8;
        }
        .sidebar-brand {
            background: linear-gradient(45deg, #667eea 0%, #764ba2 100%);
        }
    </style>
</head>
<body class="c-app">
    <!-- Sidebar -->
    <div class="c-sidebar c-sidebar-dark c-sidebar-fixed c-sidebar-lg-show" id="sidebar">
        <div class="c-sidebar-brand d-lg-down-none sidebar-brand">
            <div class="c-sidebar-brand-full">
                <strong>Gaming Panel</strong>
            </div>
            <div class="c-sidebar-brand-minimized">GP</div>
        </div>
        
        <ul class="c-sidebar-nav">
            <li class="c-sidebar-nav-item">
                <a class="c-sidebar-nav-link" href="/dashboard">
                    <i class="cil-speedometer c-sidebar-nav-icon"></i> Dashboard
                </a>
            </li>
            
            <li class="c-sidebar-nav-title">Management</li>
            <li class="c-sidebar-nav-item c-sidebar-nav-dropdown">
                <a class="c-sidebar-nav-link c-sidebar-nav-dropdown-toggle" href="#">
                    <i class="cil-people c-sidebar-nav-icon"></i> Agent Management
                </a>
                <ul class="c-sidebar-nav-dropdown-items">
                    <li class="c-sidebar-nav-item">
                        <a class="c-sidebar-nav-link" href="/agents">
                            <span class="c-sidebar-nav-icon">•</span> All Agents
                        </a>
                    </li>
                    <li class="c-sidebar-nav-item">
                        <a class="c-sidebar-nav-link" href="/agents/create">
                            <span class="c-sidebar-nav-icon">•</span> Add Agent
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="c-sidebar-nav-item c-sidebar-nav-dropdown">
                <a class="c-sidebar-nav-link c-sidebar-nav-dropdown-toggle" href="#">
                    <i class="cil-user c-sidebar-nav-icon"></i> User Management
                </a>
                <ul class="c-sidebar-nav-dropdown-items">
                    <li class="c-sidebar-nav-item">
                        <a class="c-sidebar-nav-link" href="/users">
                            <span class="c-sidebar-nav-icon">•</span> All Users
                        </a>
                    </li>
                    <li class="c-sidebar-nav-item">
                        <a class="c-sidebar-nav-link" href="/users/betting-history">
                            <span class="c-sidebar-nav-icon">•</span> Betting History
                        </a>
                    </li>
                    <li class="c-sidebar-nav-item">
                        <a class="c-sidebar-nav-link" href="/users/online">
                            <span class="c-sidebar-nav-icon">•</span> Online Users
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="c-sidebar-nav-title">Financial</li>
            <li class="c-sidebar-nav-item c-sidebar-nav-dropdown">
                <a class="c-sidebar-nav-link c-sidebar-nav-dropdown-toggle" href="#">
                    <i class="cil-credit-card c-sidebar-nav-icon"></i> Transactions
                </a>
                <ul class="c-sidebar-nav-dropdown-items">
                    <li class="c-sidebar-nav-item">
                        <a class="c-sidebar-nav-link" href="/transactions">
                            <span class="c-sidebar-nav-icon">•</span> All Transactions
                        </a>
                    </li>
                    <li class="c-sidebar-nav-item">
                        <a class="c-sidebar-nav-link" href="/transactions/balance">
                            <span class="c-sidebar-nav-icon">•</span> Balance TopUp
                        </a>
                    </li>
                </ul>
            </li>
            
            <li class="c-sidebar-nav-title">Games</li>
            <li class="c-sidebar-nav-item">
                <a class="c-sidebar-nav-link" href="/games/providers">
                    <i class="cil-gamepad c-sidebar-nav-icon"></i> Game Providers
                </a>
            </li>
            <li class="c-sidebar-nav-item">
                <a class="c-sidebar-nav-link" href="/games/list">
                    <i class="cil-list c-sidebar-nav-icon"></i> Game List
                </a>
            </li>
            
            <li class="c-sidebar-nav-title">Documentation</li>
            <li class="c-sidebar-nav-item">
                <a class="c-sidebar-nav-link" href="/docs">
                    <i class="cil-description c-sidebar-nav-icon"></i> API Documentation
                </a>
            </li>
        </ul>
        
        <button class="c-sidebar-minimizer c-class-toggler" type="button" data-target="_parent" data-class="c-sidebar-minimized"></button>
    </div>

    <!-- Main Content -->
    <div class="c-wrapper c-fixed-components">
        <!-- Header -->
        <header class="c-header c-header-light c-header-fixed c-header-with-subheader">
            <button class="c-header-toggler c-class-toggler d-lg-none mfe-auto" type="button" data-target="#sidebar" data-class="c-sidebar-show">
                <i class="cil-menu"></i>
            </button>
            
            <a class="c-header-brand d-lg-none" href="#">Gaming Panel</a>
            
            <button class="c-header-toggler c-class-toggler mfs-3 d-md-down-none" type="button" data-target="#sidebar" data-class="c-sidebar-lg-show" responsive="true">
                <i class="cil-menu"></i>
            </button>

            <ul class="c-header-nav ml-auto mr-4">
                <li class="c-header-nav-item dropdown">
                    <a class="c-header-nav-link" data-toggle="dropdown" href="#" role="button" aria-haspopup="true" aria-expanded="false">
                        <div class="c-avatar">
                            <i class="cil-user"></i>
                        </div>
                    </a>
                    <div class="dropdown-menu dropdown-menu-right pt-0 pr-5 pb-0">
                        <div class="dropdown-header bg-light py-2">
                            <strong><?= $_SESSION['admin']['agent_name'] ?? 'User' ?></strong>
                        </div>
                        <a class="dropdown-item" href="#">
                            <i class="cil-user"></i> Profile
                        </a>
                        <a class="dropdown-item" href="#">
                            <i class="cil-settings"></i> Settings
                        </a>
                        <div class="dropdown-divider"></div>
                        <a class="dropdown-item" href="/logout">
                            <i class="cil-account-logout"></i> Logout
                        </a>
                    </div>
                </li>
            </ul>
        </header>

        <!-- Subheader -->
        <div class="c-subheader px-3">
            <ol class="breadcrumb border-0 m-0">
                <li class="breadcrumb-item">Home</li>
                <li class="breadcrumb-item active"><?= $title ?? 'Dashboard' ?></li>
            </ol>
        </div>

        <!-- Body -->
        <div class="c-body">
            <main class="c-main">
                <div class="container-fluid">
                    <?php if (isset($flash) && $flash): ?>
                    <div class="row">
                        <div class="col-12">
                            <div class="alert alert-<?= $flash['type'] === 'success' ? 'success' : 'danger' ?> alert-dismissible fade show" role="alert">
                                <strong><?= $flash['title'] ?>!</strong> <?= $flash['message'] ?>
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>

                    <?= $content ?>
                </div>
            </main>
        </div>

        <!-- Footer -->
        <footer class="c-footer">
            <div>Gaming Agregator Panel <a href="#">CoreUI</a> © 2024.</div>
            <div class="ml-auto">Powered by <a href="#">Gaming API</a></div>
        </footer>
    </div>

    <!-- CoreUI JS -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@coreui/coreui@4.2.6/dist/js/coreui.bundle.min.js"></script>
    
    <!-- Custom JS -->
    <script>
        // Auto-dismiss alerts
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);
        
        // Initialize tooltips
        $(document).ready(function(){
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>
</body>
</html>