<div class="row mb-3">
    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="h4"><?= number_format($stats['total_bets'] ?? 0) ?></div>
                <div>Total Bets</div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="h4"><?= number_format($stats['total_bet_amount'] ?? 0) ?></div>
                <div>Total Bet Amount</div>
            </div>
        </div>
    </div>
    <div class="col-sm-6 col-lg-3">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="h4"><?= number_format($stats['total_win_amount'] ?? 0) ?></div>
                <div>Total Win Amount</div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4><i class="cil-chart-pie"></i> Betting History</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>User</th>
                                <th>Game</th>
                                <th>Provider</th>
                                <th>Bet Amount</th>
                                <th>Win Amount</th>
                                <th>Date</th>
                                <th>Status</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            // Get actual betting history from database
                            $db = Database::getInstance()->getConnection();
                            $stmt = $db->prepare("
                                SELECT h.*, g.game_name 
                                FROM tb_history h 
                                LEFT JOIN tb_game g ON g.game_code = h.game_code 
                                WHERE h.agent_code = ? 
                                ORDER BY h.created_at DESC 
                                LIMIT 100
                            ");
                            $stmt->execute([$_SESSION['admin']['agent_code']]);
                            $bettingHistory = $stmt->fetchAll();
                            
                            if (empty($bettingHistory)): ?>
                            <tr>
                                <td colspan="7" class="text-center text-muted py-4">No betting history found</td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($bettingHistory as $bet): ?>
                                <tr>
                                    <td><?= htmlspecialchars($bet['extUser']) ?></td>
                                    <td><?= htmlspecialchars($bet['game_name'] ?? $bet['game_code']) ?></td>
                                    <td><span class="badge badge-info"><?= htmlspecialchars($bet['provider_code']) ?></span></td>
                                    <td><?= number_format($bet['bet_money']) ?></td>
                                    <td><?= number_format($bet['win_money']) ?></td>
                                    <td><?= date('Y-m-d H:i', strtotime($bet['created_at'])) ?></td>
                                    <td>
                                        <span class="badge badge-<?= $bet['win_money'] > $bet['bet_money'] ? 'success' : 'secondary' ?>">
                                            <?= $bet['win_money'] > $bet['bet_money'] ? 'Win' : 'Loss' ?>
                                        </span>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>