<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4><i class="cil-people"></i> User Management</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="usersTable">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Internal User</th>
                                <th>External User</th>
                                <th>Balance</th>
                                <th>Agent Code</th>
                                <th>Created</th>
                                <th>Status</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($users)): ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">No users found</td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($users as $user): ?>
                                <tr>
                                    <td><?= htmlspecialchars($user['id']) ?></td>
                                    <td><code><?= htmlspecialchars($user['intUser']) ?></code></td>
                                    <td><strong><?= htmlspecialchars($user['extUser']) ?></strong></td>
                                    <td>
                                        <span class="badge badge-success">
                                            <?= number_format($user['balance']) ?>
                                        </span>
                                    </td>
                                    <td><?= htmlspecialchars($user['agent_code']) ?></td>
                                    <td><?= date('Y-m-d H:i', strtotime($user['created'])) ?></td>
                                    <td>
                                        <span class="badge badge-<?= $user['status'] == 1 ? 'success' : 'danger' ?>">
                                            <?= $user['status'] == 1 ? 'Active' : 'Inactive' ?>
                                        </span>
                                    </td>
                                    <td>
                                        <a href="/users/<?= $user['id'] ?>/details" class="btn btn-sm btn-info">
                                            <i class="cil-info"></i> Details
                                        </a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>