<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
                <h4><i class="cil-transfer"></i> User Transactions</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>Transaction ID</th>
                                <th>Internal User</th>
                                <th>External User</th>
                                <th>Type</th>
                                <th>Amount</th>
                                <th>Agent Balance Before</th>
                                <th>Agent Balance After</th>
                                <th>Date</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($transactions)): ?>
                            <tr>
                                <td colspan="8" class="text-center text-muted py-4">No user transactions found</td>
                            </tr>
                            <?php else: ?>
                                <?php foreach ($transactions as $transaction): ?>
                                <tr>
                                    <td><code><?= htmlspecialchars($transaction['trxid']) ?></code></td>
                                    <td><?= htmlspecialchars($transaction['intUser']) ?></td>
                                    <td><?= htmlspecialchars($transaction['extUser']) ?></td>
                                    <td>
                                        <span class="badge badge-<?= $transaction['type'] === 'deposit' ? 'success' : 'warning' ?>">
                                            <?= strtoupper($transaction['type']) ?>
                                        </span>
                                    </td>
                                    <td><?= number_format($transaction['amount']) ?></td>
                                    <td><?= number_format($transaction['before_agent_balance']) ?></td>
                                    <td><?= number_format($transaction['after_agent_balance']) ?></td>
                                    <td><?= date('Y-m-d H:i', strtotime($transaction['created'])) ?></td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>