<?php
// config/routes.php - Complete Route Configuration

$router = new Router();

// Public routes (no authentication)
$router->get('', 'DashboardController@index', ['Auth']);
$router->get('login', 'AuthController@showLogin');
$router->post('login', 'AuthController@login');
$router->get('logout', 'AuthController@logout');
$router->get('register', 'AuthController@showRegister');
$router->post('register', 'AuthController@register');

// Dashboard routes
$router->group('dashboard', ['Auth'], function($router) {
    $router->get('', 'DashboardController@index');
    $router->get('stats', 'DashboardController@stats');
});

// Agent management routes
$router->group('agents', ['Auth'], function($router) {
    $router->get('', 'AgentController@index');
    $router->get('create', 'AgentController@create');
    $router->post('store', 'AgentController@store');
    $router->get('{id}/edit', 'AgentController@edit');
    $router->post('{id}/update', 'AgentController@update');
    $router->post('{id}/delete', 'AgentController@delete');
    $router->post('{id}/balance', 'AgentController@updateBalance');
    $router->post('{id}/block', 'AgentController@blockAgent');
    $router->post('{id}/unblock', 'AgentController@unblockAgent');
});

// User management routes
$router->group('users', ['Auth'], function($router) {
    $router->get('', 'UserController@index');
    $router->get('{id}/details', 'UserController@details');
    $router->get('betting-history', 'UserController@bettingHistory');
    $router->get('transactions', 'UserController@transactions');
    $router->get('online', 'UserController@onlineUsers');
    $router->post('control-rtp', 'UserController@controlRtp');
});

// Transaction routes
$router->group('transactions', ['Auth'], function($router) {
    $router->get('', 'TransactionController@index');
    $router->get('balance', 'TransactionController@balance');
    $router->post('balance/topup', 'TransactionController@topup');
    $router->get('history', 'TransactionController@history');
});

// Game management routes
$router->group('games', ['Auth'], function($router) {
    $router->get('providers', 'GameController@providers');
    $router->get('list', 'GameController@gameList');
    $router->post('sync', 'GameController@syncGames');
});

// Documentation
$router->get('docs', 'DocumentationController@index', ['Auth']);

// API V1 Routes - LEGACY FORMAT (for compatibility)
$router->group('api/v1', ['ApiAuth'], function($router) {
    // Connection test
    $router->get('connection', 'ApiV1Controller@connection');
    
    // Legacy .aspx endpoints for compatibility
    $router->get('CreateMember.aspx', 'ApiV1Controller@createMember');
    $router->get('GetBalance.ashx', 'ApiV1Controller@getBalance');
    $router->get('GetBalanceAgent.ashx', 'ApiV1Controller@getAgentBalance');
    $router->get('GetProviderList.aspx', 'ApiV1Controller@getProviderList');
    $router->get('GetGameList.aspx', 'ApiV1Controller@getGameList');
    $router->get('LaunchGame.aspx', 'ApiV1Controller@launchGame');
    $router->get('MakeTransfer.aspx', 'ApiV1Controller@makeTransfer');
    $router->get('GetHistoryLog.aspx', 'ApiV1Controller@getHistoryLog');
});

// Modern RESTful API Routes
$router->group('api/v2', ['ApiAuth'], function($router) {
    // Members
    $router->post('members', 'ApiV2Controller@createMember');
    $router->get('members/{username}', 'ApiV2Controller@getMember');
    $router->get('members/{username}/balance', 'ApiV2Controller@getBalance');
    
    // Transactions
    $router->post('transactions', 'ApiV2Controller@createTransaction');
    $router->get('transactions', 'ApiV2Controller@getTransactions');
    
    // Games
    $router->get('providers', 'ApiV2Controller@getProviders');
    $router->get('games', 'ApiV2Controller@getGames');
    $router->post('games/launch', 'ApiV2Controller@launchGame');
});

return $router;