<?php
// install.php - Installation Script

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if already installed
if (file_exists('.env')) {
    die('System already installed. Delete .env file to reinstall.');
}

$step = $_GET['step'] ?? 1;

if ($_POST) {
    switch ($_POST['action']) {
        case 'check_requirements':
            $requirements = checkRequirements();
            if ($requirements['passed']) {
                header('Location: install.php?step=2');
            }
            break;
            
        case 'setup_database':
            $result = setupDatabase($_POST);
            if ($result['success']) {
                header('Location: install.php?step=3');
            }
            break;
            
        case 'create_admin':
            $result = createAdmin($_POST);
            if ($result['success']) {
                header('Location: install.php?step=4');
            }
            break;
    }
}

function checkRequirements() {
    $requirements = [
        'php_version' => version_compare(PHP_VERSION, '7.4.0', '>='),
        'pdo' => extension_loaded('pdo'),
        'pdo_mysql' => extension_loaded('pdo_mysql'),
        'curl' => extension_loaded('curl'),
        'json' => extension_loaded('json'),
        'mbstring' => extension_loaded('mbstring'),
        'writable_config' => is_writable('config/'),
        'writable_logs' => is_writable('logs/') || mkdir('logs/', 0755, true)
    ];
    
    $requirements['passed'] = !in_array(false, $requirements);
    return $requirements;
}

function setupDatabase($data) {
    try {
        $dsn = "mysql:host={$data['host']};charset=utf8mb4";
        $pdo = new PDO($dsn, $data['username'], $data['password']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Create database if not exists
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$data['dbname']}`");
        $pdo->exec("USE `{$data['dbname']}`");
        
        // Import SQL schema
        $sql = file_get_contents('database.sql');
        $pdo->exec($sql);
        
        // Create .env file
        $envContent = "DB_HOST={$data['host']}\n";
        $envContent .= "DB_NAME={$data['dbname']}\n";
        $envContent .= "DB_USERNAME={$data['username']}\n";
        $envContent .= "DB_PASSWORD={$data['password']}\n";
        $envContent .= "APP_DEBUG=false\n";
        $envContent .= "APP_KEY=" . bin2hex(random_bytes(16)) . "\n";
        
        file_put_contents('.env', $envContent);
        
        return ['success' => true];
    } catch (Exception $e) {
        return ['success' => false, 'error' => $e->getMessage()];
    }
}

function createAdmin($data) {
    try {
        $env = parse_ini_file('.env');
        $pdo = new PDO(
            "mysql:host={$env['DB_HOST']};dbname={$env['DB_NAME']};charset=utf8mb4",
            $env['DB_USERNAME'],
            $env['DB_PASSWORD']
        );
        
        $agentCode = strtoupper(bin2hex(random_bytes(4)));
        $agentToken = md5(uniqid());
        
        $stmt = $pdo->prepare("
            INSERT INTO tb_agent (agent_code, agent_name, agent_token, agent_password, agent_upline, agent_created, agent_balance, agent_level, agent_status) 
            VALUES (?, ?, ?, ?, 'sistem', NOW(), 1000000, 'admin', 'active')
        ");
        
        $stmt->execute([
            $agentCode,
            $data['admin_name'],
            $agentToken,
            md5($data['admin_password'])
        ]);
        
        return ['success' => true, 'agent_code' => $agentCode];
    } catch (Exception $e) {
        return ['success' => false, 'error' => $e->getMessage()];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gaming Agregator - Installation</title>
    <link href="https://cdn.jsdelivr.net/npm/@coreui/coreui@4.2.6/dist/css/coreui.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(45deg, #667eea 0%, #764ba2 100%); min-height: 100vh; }
        .install-container { max-width: 600px; margin: 50px auto; }
        .card { box-shadow: 0 4px 20px 0 rgba(0,0,0,.1); }
    </style>
</head>
<body>
    <div class="container install-container">
        <div class="card">
            <div class="card-header text-center">
                <h3>Gaming Agregator Installation</h3>
                <div class="progress mt-3">
                    <div class="progress-bar" style="width: <?= ($step * 25) ?>%"></div>
                </div>
            </div>
            <div class="card-body">
                <?php
                switch ($step) {
                    case 1:
                        include 'install/step1.php';
                        break;
                    case 2:
                        include 'install/step2.php';
                        break;
                    case 3:
                        include 'install/step3.php';
                        break;
                    case 4:
                        include 'install/step4.php';
                        break;
                    default:
                        echo '<p>Installation completed!</p>';
                }
                ?>
            </div>
        </div>
    </div>
</body>
</html>