<h4>Step 1: System Requirements</h4>
<?php
$requirements = checkRequirements();
?>
<div class="table-responsive">
    <table class="table">
        <tr class="<?= $requirements['php_version'] ? 'table-success' : 'table-danger' ?>">
            <td>PHP Version ≥ 7.4</td>
            <td><?= $requirements['php_version'] ? '✓ ' . PHP_VERSION : '✗ ' . PHP_VERSION ?></td>
        </tr>
        <tr class="<?= $requirements['pdo'] ? 'table-success' : 'table-danger' ?>">
            <td>PDO Extension</td>
            <td><?= $requirements['pdo'] ? '✓ Available' : '✗ Not Available' ?></td>
        </tr>
        <tr class="<?= $requirements['pdo_mysql'] ? 'table-success' : 'table-danger' ?>">
            <td>PDO MySQL Extension</td>
            <td><?= $requirements['pdo_mysql'] ? '✓ Available' : '✗ Not Available' ?></td>
        </tr>
        <tr class="<?= $requirements['curl'] ? 'table-success' : 'table-danger' ?>">
            <td>cURL Extension</td>
            <td><?= $requirements['curl'] ? '✓ Available' : '✗ Not Available' ?></td>
        </tr>
    </table>
</div>

<?php if ($requirements['passed']): ?>
<form method="POST">
    <input type="hidden" name="action" value="check_requirements">
    <button type="submit" class="btn btn-primary">Continue to Database Setup</button>
</form>
<?php else: ?>
<div class="alert alert-danger">
    Please fix the requirements above before continuing.
</div>
<?php endif; ?>