
$(document).ready(function() {
    // Auto-dismiss alerts after 5 seconds
    setTimeout(function() {
        $('.alert').fadeOut('slow');
    }, 5000);
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Initialize popovers
    $('[data-toggle="popover"]').popover();
    
    // Confirm delete actions
    $('.btn-delete').on('click', function(e) {
        e.preventDefault();
        const message = $(this).data('message') || 'Are you sure you want to delete this item?';
        if (confirm(message)) {
            const form = $(this).closest('form');
            if (form.length) {
                form.submit();
            } else {
                window.location.href = $(this).attr('href');
            }
        }
    });
    
    // Format numbers with thousand separators
    $('.format-number').each(function() {
        const number = parseInt($(this).text());
        $(this).text(number.toLocaleString());
    });
    
    // Auto-refresh stats every 30 seconds on dashboard
    if (window.location.pathname === '/dashboard') {
        setInterval(function() {
            fetch('/dashboard/stats')
                .then(response => response.json())
                .then(data => {
                    if (data.status === 'success') {
                        // Update stats display
                        updateStats(data.data);
                    }
                })
                .catch(error => console.error('Error refreshing stats:', error));
        }, 30000);
    }
});

function updateStats(stats) {
    // Update dashboard statistics
    Object.keys(stats).forEach(key => {
        const element = document.getElementById('stat-' + key);
        if (element) {
            element.textContent = stats[key].toLocaleString();
        }
    });
}

// Global AJAX error handler
$(document).ajaxError(function(event, xhr, settings, thrownError) {
    if (xhr.status === 401) {
        alert('Session expired. Please login again.');
        window.location.href = '/login';
    } else if (xhr.status === 403) {
        alert('Access denied.');
    } else if (xhr.status >= 500) {
        alert('Server error. Please try again later.');
    }
});

// Utility function for making API calls
function makeApiCall(url, method = 'GET', data = null) {
    return fetch(url, {
        method: method,
        headers: {
            'Content-Type': 'application/json',
            'X-Requested-With': 'XMLHttpRequest'
        },
        body: data ? JSON.stringify(data) : null
    }).then(response => {
        if (!response.ok) {
            throw new Error(`HTTP error! status: ${response.status}`);
        }
        return response.json();
    });
}